d("productListPageView", ['util', 'ccrz'], function (util, productListPageView) {
    return {
        extendproductListPageView: function (productListPageView) {
            CCRZ.subsc = _.extend(CCRZ.subsc || {});
            CCRZ.subsc.productListRemoting = _.extend(CCRZ.RemoteInvocation, {
                className: 'OXB2B_ProductListController',
                checkForInventory: function (reqData, callback) {
                    this.invokeCtx('checkInventory',
                        reqData,
                        function (resp, evt) {
                            if (callback) {
                                callback(resp, evt);
                            }
                        },
                        {
                            buffer: false, //this call will be executed by itself 
                            nmsp: false //defines that this is a call to a subscriber class 
                        }
                    );//end invokeCtx call 
                }

            });


            CCRZ.productListPageView.delegateEvents(_.extend(CCRZ.productListPageView.events,
                {
                    "click .in_stock_availability_icon": this.checkInventory,
                    "click .in_stock_availability_text_close": this.closeInStockAvailability,
                }
            ));
            CCRZ.productListPageViewWasRendered = false;
            CCRZ.pubSub.on("view:productListPageView:refresh", function (view) {
                CCRZ.productListPageViewWasRendered = true;
                CCRZ.productListPageView.headerView.setElement(CCRZ.uiProperties.productListPageView.header.selector);
                CCRZ.productListPageView.productItemsView.setElement(CCRZ.uiProperties.productListPageView.productItems.selector);
                CCRZ.productListPageView.footerView.setElement(CCRZ.uiProperties.productListPageView.footer.selector);

                if (CCRZ.CategoryTree) {
                    CCRZ.CategoryTree.render();
                }
            });
            let isFilterRefreshed = false;
            CCRZ.pubSub.on("view:productListFilterView:refresh", function (filterView) {
                filterView.specGroupsView.setElement(CCRZ.uiProperties.productListFilterView.ListView.selector);
                filterView.renderDesktop = function () {
                    this.$el.html(this.template());
                    filterView.specGroupsView.refreshView();
                    setTimeout(function () {
                        filterView.specGroupsView.postRender();
                    }, 3000);
                    return this;
                };
                filterView.delegateEvents();
                if (!isFilterRefreshed) {
                    isFilterRefreshed = true;
                    filterView.render();
                }

            });
            CCRZ.pubSub.on("view:specGroupView:refresh", function (filterView) {
                var windowWidth = $(window).width();
                var mobileThreshold = 768;
                if (windowWidth < mobileThreshold) {
                    $('.icon-.cc_filter_icon').addClass("collapsed");
                    $('.icon-.cc_filter_icon').attr("aria-expanded","false");

                    $('.panel-collapse.collapse.in').attr("aria-expanded","false");
                    $('.panel-collapse.collapse.in').css("height", "0");
                    $('.panel-collapse.collapse.in').removeClass("in"); 
                }

                filterView.events["update .cc_slider"] = 'performRangeFilter';
                filterView.events["click .cc_filter_checkbox"] = 'toggleSelected';
                filterView.performRangeFilter = function (event, values) {
                    var objLink = $(event.currentTarget), isRangeSame = false;
                    this.model.set('filterMin', values[0], { silent: true });
                    this.model.set('filterMax', values[1], { silent: true });
                    if (values[0] == values[1]) {
                        isRangeSame = true;
                    }
                    var filter = _.pick(this.model.toJSON(), 'sfid', 'name', 'filterType', 'filterMin', 'filterMax');

                    CCRZ.appliedFilters.set(filter, { parse: false, remove: false, merge: true });
                    if (CCRZ.ga) {
                        CCRZ.ga.handleFeatureFilter(objLink);
                    }
                    if (!isRangeSame) {
                        $('.messagingSection-Error-filter').css('display', 'none');
                        CCRZ.pubSub.trigger("view:productListFilterView:applyFilters", CCRZ.appliedFilters);
                        //UI Silder render on changing values, timeout for workaround to fix UI silder
                        //CCRZ.productListFilterView.specGroupsView.refreshView();
                        CCRZ.productListFilterView.render();
                    } else {
                        window.scrollTo(0, 0);
                        var msgContext = CCRZ.createPageMessage('ERROR', 'messagingSection-Error-filter', 'Silder Range Could not be the same!');
                        CCRZ.pubSub.trigger("pageMessage", msgContext);
                    }
                };
                filterView.toggleSelected = function (event) {
                    var objLink = $(event.currentTarget);
                    var filter = _.pick(this.model.toJSON(), 'sfid', 'name', 'filterType');

                    var specGroupValues = this.model.get('specValues');
                    var toUpdate = specGroupValues.find({ value: objLink.attr("data-value") });
                    toUpdate.set('selected', objLink.is(':checked'));

                    var appliedFilters = _.where(specGroupValues.toJSON(), { selected: true });
                    if (appliedFilters.length != 0) {
                        filter.specValues = appliedFilters;
                        CCRZ.appliedFilters.set(filter, { parse: false, remove: false, merge: true });
                    } else {
                        CCRZ.appliedFilters.remove(filter);
                    }
                    if (CCRZ.ga && objLink.is(':checked')) {
                        CCRZ.ga.handleFeatureFilter(objLink);
                    }
                    CCRZ.pubSub.trigger("view:productListFilterView:applyFilters", CCRZ.appliedFilters);
                    CCRZ.productListFilterView.render();
                };

                filterView.delegateEvents();
            });
            let populateCategoryName = false;

            CCRZ.pubSub.on("view:productListHeader:refresh", function (prodHeaderView) {
                if (!populateCategoryName) {
                    populateCategoryName = true;
                    setTimeout(function () {
                        populateCategoryId();
                    }, 2000);
                }
                
                prodHeaderView.events["click .cc_remove_filters"] = 'removeAllFilters';
                //prodHeaderView.events["click .cc_remove_filter"] = 'removeFilter';
                prodHeaderView.removeAllFilters = function (event) {
                    CCRZ.pubSub.trigger("view:" + this.viewName + ":removeAllFilters");
                    CCRZ.productListFilterView.render();
                }

                prodHeaderView.removeFilter = function (event) {
                    var objLink = $(event.currentTarget);
                    var specId = objLink.data("specid");
                    var specValue = '' + objLink.data("specvalue");
                    CCRZ.pubSub.trigger("view:" + this.viewName + ":removeFilter", { sfid: specId, value: specValue });
                    CCRZ.productListFilterView.render();
                }
                prodHeaderView.delegateEvents();
            });

            CCRZ.pubSub.on("view:wishlistPickerModal:refresh", function (view) {
                view.events["click .custom_pickWish"] = 'handleClickPickWish';
                view.handleClickPickWish = function (e) {
                    var objLink = $(e.currentTarget);
                    var id = objLink.data("id");
                    var name = objLink.data("name");
                    this.processAddItem(objLink, id);
                    $.confirm({
                        title: 'Successful',
                        content: `Added to default favorites: ${name}`,
                        closeIcon: true,
                        draggable: false,
                        buttons: {
                            'Go to Favorites': function () {
                                if (id && id != null && id != '') {
                                    $('#sidebarBackdrop').removeClass('hide');
                                    var href = CCRZ.pagevars.currSiteURL + "ccrz__MyAccount?viewstate=myWishlists&wishlist=" + id + "&cartId=" + CCRZ.pagevars.currentCartID + getCSRQueryString();
                                    let iframe = document.createElement('iframe');
                                    iframe.src = href;
                                    iframe.style.display = 'none';
                                    iframe.onload = function () {
                                        window.location.href = iframe.src;
                                    }
                                    document.body.appendChild(iframe);
                                }
                            },
                            OK: {

                            }
                        }
                    });
                }
                view.processAddItem = function (obj, val) {
                    var parentObj = obj.closest('.wishFinder');
                    var sku = parentObj.data("sku");
                    var createName = obj.closest(CCRZ.uiProperties.wishlistPickerModal.nameSelector).find('.newListName').val();
                    var v = this;
                    this.invokeContainerLoadingCtx($('.deskLayout'), 'handleAddtoWishlist', sku, val, createName, function (response) {
                        CCRZ.pubSub.trigger('refreshWishlists', val);
                        if (val == '-1') {
                            v.refresh();
                        }
                    });
                }
            });
            /* CCRZ.pubSub.on("action:productsPageRenderAllViews", function() {
                   CCRZ.productListPageView.render();
                   CCRZ.productListPageView.headerView.render();
                   CCRZ.productListPageView.productItemsView.render();
                   CCRZ.productListPageView.footerView.render();
                   
               });*/
            CCRZ.pubSub.on("action:productsPageRenderAllViews", function () {
                CCRZ.productListPageView.render();
                CCRZ.productListPageView.headerView.render();
                CCRZ.productListFilterView.specGroupsView.render(); /// Add it for  for Product Specs
                CCRZ.productListPageView.productItemsView.render();
                CCRZ.productListPageView.footerView.render();

            });
            let stockAvailabilityCall = false;
            let populateSpecInfo = false;
            CCRZ.pubSub.on("view:productItemView:refresh", function (view) {
                if (!CCRZ.pagevars.isGuest) {
                    /*let productCode=view.model.attributes.SKU;                
                    let quantity = '1';
                    let reqData = {productCode : productCode,quantity:quantity}; 
                    var div= $("#inStock_"+productCode);             
                    CCRZ.subsc.productListRemoting.checkForInventory(JSON.stringify(reqData),function(res,event){
                        if(event.status){
                            let resultDetail = event.result.data;
                            if(resultDetail && resultDetail.stock.Message){
                                  $(div).find('.in_stock_availability_text').html(resultDetail.stock.Message);
                            }
                        }
                    });*/

                    //Stock availability API call
                    if (!stockAvailabilityCall) {
                        stockAvailabilityCall = true;
                        setTimeout(function () {
                            stockAvailabilityCall = false;
                        }, 2000);
                        checkStockAvailability();
                    }
                }
                if (!populateSpecInfo) {
                    populateSpecInfo = true;
                    setTimeout(function () {
                        populateSpecInfo = false;
                        populateSpecHelpText();
                    }, 1000);
                }
            });

            function checkStockAvailability() {
                var plpItems = CCRZ.productListPageView.productItemsView.collection.models;
                var skuArray = [];
                var i = 0;
                for (i = 0; i < plpItems.length; i++) {
                    let productCode = plpItems[i].attributes.SKU;
                    skuArray.push(productCode);
                }

                let reqData = { productCodes: skuArray };
                console.log(reqData);
                if (plpItems.length > 0) {
                    CCRZ.subsc.productListRemoting.checkForInventory(JSON.stringify(reqData), function (res, event) {
                        if (event.status) {
                            console.log(event.result.data);
                            let resultDetail = event.result.data.stock;
                            if (resultDetail[0]) {
                                for (i = 0; i < skuArray.length; i++) {
                                    var code;
                                    var respQty;
                                   var itemQty;
                                    var respColor;
                                    if (resultDetail[0].error != null) {
                                        code = skuArray[i];
                                    //    respQty = resultDetail[0].errorMessage;
                                        itemQty = resultDetail[0].errorMessage;
                                        respColor = resultDetail[0].respColor;
                                    }
                                    else {
                                        code = resultDetail[i].itemNumber;
                                        respQty = resultDetail[i].itemAvailability;
                                      itemQty = resultDetail[i].itemAvailabilityQty;
                                        respColor = resultDetail[i].respColor;
                                    }
                                    if (resultDetail[i]?.itemAvailability === 'Low Stock' || resultDetail[i]?.itemAvailability === 'In Stock' || resultDetail[i]?.itemAvailability === 'Back Ordered' || resultDetail[i]?.itemAvailability === 'Reserve Now') {
                                        $(".plpDisabled_" + code).attr('disabled', false);
                                    } else {
                                        $(".plpDisabled_" + code).attr('disabled', true);
                                    }

                                    if (itemQty > 0) {
                                        $("#stockAvailability" + code).html(' ' + itemQty );
                                    } else if(itemQty == 0 || respQty === 'Back Ordered' || itemQty < 0){
                                        $("#stockAvailability" + code).html(' ' + 'Reserve Now');
                                        // $("#stockAvailability" + code).html('');
                                    }
                                    // $("#stockAvailability" + code).html(' ' + itemQty);
                                    $(".stockAvailabilityMessage_" + code).addClass(respColor);
                                }
                            }
                        }
                    });
                }
            };
            function populateCategoryId() {
                let categoryId = CCRZ.productListPageView.model.attributes.category?.sfdcName;
                if (categoryId) {
                    $('.effleft').append('<div class="cc_panel cc_productlist_title">' +
                                            '<div class="panel-body cc_heading">' +
                                                '<p class="panel-title cc_title">' +
                                                    categoryId +
                                                '</p>' +
                                            '</div>' +
                                        '</div>');
                } else {
                    $('.effleft').append('<div class="cc_panel cc_productlist_title">' +
                                            '<div class="panel-body cc_heading">' +
                                                '<p class="cc_search_title cc_title" style="margin-top: -12px;">' +
                                                    CCRZ.processPageLabelMap('ProductList_SearchResults') +
                                                '</p>' +
                                            '</div>' +
                                        '</div>');
                }
            };
            function populateSpecHelpText() {
                var specItems = CCRZ.productListFilterView.specGroupsView.collection.models;
                var sfidArray = [];
                var i = 0;
                for (i = 0; i < specItems.length; i++) {
                    let sfidtCode = specItems[i].attributes.sfid;
                    sfidArray.push(sfidtCode);
                }
                let reqData = { specId: sfidArray };
                console.log(reqData);
                if (sfidArray.length > 0) {
                    var remoteCall = _.extend(CCRZ.RemoteInvocation, { className: 'OXB2B_ProductListController' });
                    remoteCall.invokeCtx(
                        'fetchSpecHelpText', (JSON.stringify(reqData)),
                        function (response, event) {
                            if (response.success && response.data.data) {
                                let data = response.data.data;
                                sfidArray.forEach(spid => {
                                    if (data[spid]) {
                                        $(".spec" + spid).append('<i class="icon-help" data-toggle="' + data[spid] + '" title="' + data[spid] + '"></i>');
                                    }
                                });
                            }
                        }, { buffer: false, nmsp: false }
                    );
                }
            }

        }, checkInventory: function (event) {
            var div = event.currentTarget.firstElementChild;
            $(div).show();

        },
        closeInStockAvailability: function (event) {
            let productCode = event.currentTarget.parentElement;
            $(productCode).hide();
            event.stopPropagation();
        }
    }
});