/**
 *  Namespace defines additional handlebars helpers. That could be used in whole storefront
 *
 *  <ul>
 *  <li>
 *      ifPageDisplay - render block or not depend on current ccpage
 *      <pre>
 *              {{#ifPageDisplay 'ccrz__HomePage'}}
 *              <h1>Home page</h1>
 *              {{/ifPageDisplay}}
 *      </pre>
 *  </li>
 *  <li>
 *      ifConfigValue - helpers renders block or not depend on current storefront and sales organization
 *      <pre>
 *              {{#ifConfigValue 'Checkout_DeliveryDate__c'}}
 *                  <div class="col-md-5 col-xs-12  section">
 *                      <div><label>{{pageLabelMap 'CHECKOUT_DELIVERYDATE_LABEL'}} </label></div>
 *                       <div><input type="date" name="date" /></div>
 *                  </div>
 *              {{/ifConfigValue}}
 *      </pre>
 * </li>
 *  </ul>
 */
d('helpers', ['hbs', 'util'], function (Handlebars, util) {
    var initialized = false;
    return {
        registerHelpers: function () {
            if (!initialized) {
                //api pricing for wishitem. The attribute name in CCRZ is different from PLP.
                Handlebars.registerHelper('populateFeatured', function (product) {
                    let sku = product.sku;
                    let productSKUWithoutSpace = sku.replace(/ /g, "_");
                    let priceDiv = 'cc_featured_price' + productSKUWithoutSpace;
                    let uomDiv = 'cc_featured_uom' + productSKUWithoutSpace;
                    let quantityDiv = 'cc_featured_qty' + productSKUWithoutSpace;
                    let shipToId = CCRZ.getCookie('apex__shipToAccountId') ? CCRZ.getCookie('apex__shipToAccountId') : '';
                    let uom = product.UnitOfMeasure;
                    let quantity = 1;
                    let cartItemId = '';
                    populatePriceOnly(priceDiv, uomDiv, quantityDiv, shipToId, sku, uom, quantity);
                });
                Handlebars.registerHelper('populateWishItem', function (product) {
                    let sku = product.sku;
                    let productSKUWithoutSpace = sku.replace(/ /g, "_");
                    let uom = product.UnitOfMeasure;
                    let priceDiv = 'cc_price' + productSKUWithoutSpace;
                    let optionsDiv = 'cc_product_uom' + productSKUWithoutSpace;
                    let shipToSelect = CCRZ.getCookie('apex__shipToAccountId') ? CCRZ.getCookie('apex__shipToAccountId') : '';
                    let quantityDiv = 'cc_entry' + productSKUWithoutSpace;
                    populatePrice(priceDiv, optionsDiv, shipToSelect, sku, 1, uom, quantityDiv, '');
                });
                //api pricing for spotlight and featured product. There is no quantity and uom input.
                Handlebars.registerHelper('populateSpotlight', function (product) {
                    let sku = product.sku;
                    let skuWithoutSpace = sku.replace(/ /g, "_");
                    let priceDiv = 'cc_spotlight_price' + skuWithoutSpace;
                    let uomDiv = 'cc_spotlight_uom' + skuWithoutSpace;
                    let quantityDiv = 'cc_spotlight_qty' + skuWithoutSpace;
                    let shipToId = CCRZ.getCookie('apex__shipToAccountId') ? CCRZ.getCookie('apex__shipToAccountId') : '';
                    let uom = product.UnitOfMeasure;
                    let quantity = 1;
                    let cartItemId = '';
                    populatePriceOnly(priceDiv, uomDiv, quantityDiv, shipToId, sku, uom, quantity);
                });
                //api pricing for PLP
                Handlebars.registerHelper("populatePLPMap", function (product) {
                    /*productSKUandUOM = [product.SKU,product.unitOfMeasure];
                        if(!PLPmap.includes(productSKUandUOM)){
                            PLPmap.push(productSKUandUOM);
                        }
                    }
                     */

                    if (CCRZ.pagevars.currentPageName == 'ccrz__ProductList') {
                        return;
                    }

                    if (typeof product != 'undefined' && product !== "") {
                        let sku = product.SKU;
                        let skuWithoutSpace = sku.replace(/ /g, "_");
                        let uom = product.unitOfMeasure;
                        let priceDiv = 'cc_price' + skuWithoutSpace;
                        let optionsDiv = 'cc_product_uom' + skuWithoutSpace;
                        let shipToSelect = CCRZ.getCookie('apex__shipToAccountId') ? CCRZ.getCookie('apex__shipToAccountId') : '';
                        let quantityDiv = 'cc_entry' + skuWithoutSpace;
                        let skuQty = 1;
                        if (product.quantityperunit) {
                            skuQty = product.quantityperunit;
                        }
                        populatePrice(priceDiv, optionsDiv, shipToSelect, sku, skuQty, uom, quantityDiv, '');
                        /*
                        let pgSize = parseInt(CCRZ.productListPageModel.attributes.pageSize);
                        let currentIndex = parseInt(product.index);
                        if(pgSize && currentIndex){
                            currentIndex++;
                            let rem =  currentIndex%pgSize;
                            if(rem==0){
                                let timeout = 5000;
                                if(pgSize==10){
                                    timeout = 5000;
                                }else if(pgSize==25){
                                    timeout = 12000;
                                }else if(pgSize==50){
                                    timeout = 24000;
                                }else if(pgSize==75){
                                    timeout = 36000;
                                }
                                setTimeout(function(){$('.cc_show_more').attr('disabled',false).prop('title','');},timeout);
                            }
                        }
                        */
                    }
                });
                // show elements on pageName
                Handlebars.registerHelper('ifPageDisplay', function (pageName, options) {
                    if (CCRZ.pagevars.currentPageName.toLowerCase() === pageName.toLowerCase()) {
                        return options.fn(this);
                    }
                    else {
                        return options.inverse(this);
                    }
                });
                // show elements on pageName
                Handlebars.registerHelper('ifNotPageDisplay', function (pageName, options) {
                    return (CCRZ.pagevars.currentPageName.toLowerCase() !== pageName.toLowerCase()) ? true : false;
                });
                //get value from config
                Handlebars.registerHelper('getConfig', function (str) {
                    return CCRZ.pagevars.pageConfig[str];
                });
                //check if obejct is empty
                Handlebars.registerHelper('ifObjectExistButIsEmpty', function (obj) {
                    if (obj.length === 1) {
                        var isEmpty = _.isEmpty(obj[0]);
                        if (isEmpty) { return true; }
                    }
                    else if (obj.length === 0) { return true; }
                    else { return false; }
                });
                //return object size
                Handlebars.registerHelper("objectSize", function (object) {
                    if (object) {
                        return Object.keys(object).length;
                    }
                    return null;
                });
                Handlebars.registerHelper('ifOneItemWithOneQty', function (productArray, groupModel, modelOrder) {
                    var size = productArray.length;
                    var flag = false;
                    if (modelOrder) {
                        var itemList = groupModel[0].attributes.EOrderItemsS[0];
                    } else {
                        var itemList = groupModel[0].attributes.ECartItemsS[0];
                    }
                    if (size === 1 && itemList) {
                        var qty = itemList.quantity;
                        if (qty === 1) { flag = true; }
                    }
                    return flag;
                });
                Handlebars.registerHelper('or', function (val1, val2) {
                    if (val1 || val2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('and', function (val1, val2) {
                    if (val1 && val2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('subcategoryIsCurrentCategory', function (subcategories, currentCategoryId) {
                    var isCurrent = false;
                    _.each(subcategories, function (subcategory) {
                        var subId = subcategory.categoryID;
                        if (subId === currentCategoryId) {
                            isCurrent = true;
                        }
                    });
                    return isCurrent;
                });
                Handlebars.registerHelper('getCurrentPLPCategoryId', function () {
                    if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isCategory) {
                        var categoryId = CCRZ.productListPageModel.attributes.category.categoryID;
                        return categoryId;
                    } else if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isSearch) {
                        return '';
                    }
                });
                Handlebars.registerHelper('getCategoryImages', function () {
                    if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isCategory) {
                        var categoryId = CCRZ.productListPageModel.attributes.category.categoryID;
                        return categoryId;
                    } else if (CCRZ.productListPageModel && CCRZ.productListPageModel.attributes.isSearch) {
                        return '';
                    }
                });
                Handlebars.registerHelper('getCurrentIterationEan', function (productId, productList) {
                    var item = productList[productId];
                    return item.cccustEAN;
                });
                Handlebars.registerHelper('findPaginationIdTarget', function () {
                    var target = $("[id$='pagin-target']");
                    var targetId = target.attr("id");
                    return targetId;
                });
                Handlebars.registerHelper('getNumberOfAlerts', function () {
                    if (CCRZ.AlertView && CCRZ.AlertView.model) {
                        return CCRZ.AlertView.model.length;
                    } else {
                        return 0;
                    }
                });
                Handlebars.registerHelper('returnListOfAttributes', function (productList, nameOfAttribute) {
                    var attributeArray = [];
                    _.each(productList, function (product) {
                        attributeArray.push(product[nameOfAttribute]);
                    });
                    return attributeArray.join(', ');
                });
                Handlebars.registerHelper('getAlertsTotal', function () {
                    if (CCRZ.AlertView && CCRZ.AlertView.model) {
                        var cookie = CCRZ.getCookie('seenAlerts');
                        if (!cookie) {
                            cookie = [];
                            var jsonidList = JSON.stringify(cookie);
                            CCRZ.setCookieWithPath('seenAlerts', jsonidList, 30, '/');
                            var cookie = CCRZ.getCookie('seenAlerts');
                            var seen = JSON.parse(cookie);
                        } else {
                            var seen = JSON.parse(cookie);
                        }

                        var seenAmount = seen.length,
                            alerts = CCRZ.AlertView.model.length;

                        if (seen && seenAmount > 0) {
                            return alerts - seenAmount;
                        } else {
                            return alerts;
                        }
                    } else {
                        return 0;
                    }
                });
                Handlebars.registerHelper('equals', function (value1, value2) {
                    if (value1 === value2) {
                        return true;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('ifGreaterOrEqual', function (v1, v2, options) {
                    if (v1 >= v2) {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('reverse', function (arr) {
                    arr.reverse();
                });
                Handlebars.registerHelper('debug2', function (data, desc) {
                    //console.log(data);
                    return '';
                });
                Handlebars.registerHelper('getProductType', function () {
                    return CCRZ.detailData.jsonProductData.product.prodBean.ProductType;
                });
                Handlebars.registerHelper('getResourceUrl', function (str) {
                    return CCRZ.pagevars.themeBaseURL + str;
                });
                Handlebars.registerHelper('ifPageKey', function (pageKey) {
                    return (pageKey == CCRZ.getQueryParam('pageKey')) ? true : false;
                });
                Handlebars.registerHelper('getShippingProvider', function (index) {
                    if (index >= 0 && CCRZ.LLIShippingDetailModel) {
                        var model = CCRZ.LLIShippingDetailModel.attributes.cartData.ECartItemGroupsS.models[index];
                        var shippingProvider = model.attributes.shipProvider;
                        return shippingProvider;
                    } else {
                        return Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                    }
                });
                Handlebars.registerHelper('getShippingProviderByMethod', function (shipGroup) {
                    if (shipGroup && CCRZ.LLIShippingDetailModel) {
                        var shippingOptions = shipGroup.shippingOptions;
                        var provider = Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                        _.each(shippingOptions, function (option) {
                            if (option.serviceName == shipGroup.shipMethod) {
                                provider = option.provider;
                            }
                        }, shipGroup);
                        return provider;
                    } else {
                        return Handlebars.helpers.pageLabelMap('ShippingRate_Provider_Unknown');
                    }
                });
                Handlebars.registerHelper('checkIfInCartIsCoupon', function (cartItems) {
                    var checkResult = false;

                    $.each(cartItems.models, function (index, element) {
                        if (element.attributes.cartItemType == 'Coupon') {
                            checkResult = true;
                        }
                    });

                    return checkResult;
                });

                Handlebars.registerHelper('allDiscount', function (cartItems) {
                    var discount = 0;

                    if (Handlebars.helpers.checkIfInCartIsCoupon(cartItems)) {
                        $.each(cartItems.models, function (index, element) {
                            if (element.attributes.cartItemType == 'Coupon') {
                                discount += -(element.attributes.SubAmount);
                            }
                        });
                    } else {
                        $.each(cartItems.models, function (index, element) {
                            if (element.attributes.absoluteDiscount) {
                                discount += element.attributes.absoluteDiscount;
                            }
                        });
                    }

                    return discount;
                });
                Handlebars.registerHelper('checkIfShowSaveLabels', function (cartItems) {
                    var checkResult = false;
                    var checkVariable = Handlebars.helpers.allDiscount(cartItems);
                    if (checkVariable != 0) {
                        checkResult = true;
                    }

                    return checkResult;
                });
                //check is mobile or width less than breakpoint
                Handlebars.registerHelper('checkMobile', function (breakpoint) {
                    var screensize = $(window).width(),
                        breakpoint = Number(breakpoint);

                    return (screensize < breakpoint) ? true : false;
                });
                Handlebars.registerHelper('switchMonthDay', function (dataToConvert) {
                    dateFormat = CCRZ.pagevars.pageLabels['Date_Format'];
                    if (dataToConvert.includes("/")) {
                        let parts = dataToConvert.split("/");
                        day = parts[0];
                        month = parts[1];
                        year = parts[2];
                    } else if (dataToConvert.includes("-")) {
                        let parts = dataToConvert.split("-");
                        year = parts[0] + parts[2].substring(2, parts[2].length);
                        month = parts[1];
                        day = parts[2].substring(0, 2);
                    } else {
                        //console.log('unknown date format detected');
                        return;
                    }

                    switch (dateFormat) {
                        case 'yyyy/mm/dd':
                            return year + '/' + month + '/' + day;
                        case 'dd/mm/yyyy':
                            return day + '/' + month + '/' + year;
                        default:
                            return month + '/' + day + '/' + year;
                    }
                });
                Handlebars.registerHelper('convertDate', function (dataToConvert) {
                    //getting local time versus GMT/UTC time difference in minutes
                    let timeDifference = new Date().getTimezoneOffset();
                    let reqdateValue = parseInt(dataToConvert) + Math.abs(timeDifference) * 60 * 1000;

                    var format = CCRZ.pagevars.pageLabels['Date_Format'];
                    return util.formatDate(new Date(reqdateValue), format);
                });
                Handlebars.registerHelper('compareDate', function (dateToCompare) {
                    if (dateToCompare != undefined && dateToCompare != '') {
                        var todayDate = new Date(),
                            convertDate = new Date(dateToCompare);
                        return (todayDate.toLocaleDateString() < convertDate.toLocaleDateString()) ? true : false;
                    } else {
                        return false;
                    }
                });
                Handlebars.registerHelper('ifNotPastDate', function (dateToCompare) {
                    if (dateToCompare != undefined && dateToCompare != '') {
                        var todayDate = new Date(),
                            convertDate = new Date(dateToCompare);
                        return (Date.parse(convertDate.toLocaleDateString()) >= Date.parse(todayDate.toLocaleDateString())) ? true : false;
                    } else {
                        return true;
                    }
                });
                Handlebars.registerHelper('isStock', function (value, options) {
                    if (CCRZ.pagevars.pageConfig['pd.dsplavlb']
                        && CCRZ.pagevars.storeSettings['InventoryCheckFlag__c']
                        && value != undefined
                        && value != ''
                        && value > 0) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('addOne', function (value, options) {
                    return value + 1;
                });
                Handlebars.registerHelper('displayDocumentName', function (value, options) {
                    if (value) {
                        let documentName = value.split('/').pop();
                        let name = documentName.split('.');
                        return name[0];
                    } else {
                        return '';
                    }
                });
                Handlebars.registerHelper('getProdCategory', function (options) {
                    let friendlyUrl = CCRZ.breadcrumbView.model._previousAttributes.siteIndex?.friendlyURL;
                    if (friendlyUrl) {
                        return friendlyUrl.split('/').pop();
                    } else {
                        return 'Product Detail';
                    }
                });
                Handlebars.registerHelper('isGuest', function (options) {
                    if (!CCRZ.pagevars.isGuest) {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('isNotGuest', function (options) {
                    if (!CCRZ.pagevars.isGuest) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isLoggedUser', function (options) {
                    if (CCRZ.pagevars.isGuest) {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });


                Handlebars.registerHelper('isProductList', function (options) {
                    if (CCRZ.pagevars.currentPageName === 'ccrz__ProductList') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isOrderView', function (options) {
                    if (CCRZ.pagevars.currentPageName.toLowerCase() === 'ccrz__orderview') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isNotOrderView', function (options) {
                    if (CCRZ.pagevars.currentPageName.toLowerCase() !== 'ccrz__orderview') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isNotProductList', function (options) {
                    if (CCRZ.pagevars.currentPageName != 'ccrz__ProductList') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isCheckoutNew', function (options) {
                    if (CCRZ.pagevars.currentPageName === 'ccrz__CheckoutNew') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isCart', function (options) {
                    if (CCRZ.pagevars.currentPageName === 'ccrz__Cart') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isNotCart', function (options) {
                    if (CCRZ.pagevars.currentPageName != 'ccrz__Cart') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('showChangeAccount', function (options) {
                    var currentURL = window.location.href;
                    blockedPages = ["ccrz__CheckoutNew", "ccrz__OrderConfirmation", "ccrz__OrderView"];
                    for (let i = 0; i < blockedPages.length; i++) {
                        if (currentURL.indexOf(blockedPages[i]) > -1) {
                            return options.inverse(this);
                        }
                    }
                    return options.fn(this);
                });
                Handlebars.registerHelper('ifEven', function (conditional, options) {
                    if ((conditional % 2) == 0) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('strong', function (value) {
                    value = value.replace(new RegExp('<em>', 'g'), '<strong>');
                    value = value.replace(new RegExp('</em>', 'g'), '</strong>');
                    return value;
                });
                Handlebars.registerHelper('productLinkSearch', function (product, styleClass, options) {
                    var SKU = '';
                    if (!_.isUndefined(product)) {
                        if (product.linkURL) {
                            SKU = product.linkURL;
                        } else if (product.sku) {
                            SKU = product.sku;
                        } else if (product.SKU) {
                            SKU = product.SKU;
                        } else if (product.productSKU) {
                            SKU = product.productSKU;
                        }
                        var productName = product.highlightName || product.name
                        productName = Handlebars.helpers.strong(productName);
                        var linkObj = {
                            'name': productName,
                            'SKU': SKU,
                            'friendlyUrl': product.friendlyUrl,
                            'openInNewWindow': product.openInNewWindow
                        };
                        var productJSON = _.escape(JSON.stringify(linkObj));
                    }
                    var content = '';
                    if (productName) {
                        content = _.unescape(productName);
                    }
                    if (options && options.hash['image']) {
                        content = options.hash['image'];
                    }
                    if (options && options.hash['text']) {
                        content = _.escape(_.unescape(options.hash['text']));
                    }
                    return new Handlebars.SafeString("<a href=\"javascript:void(0);\" onClick=\"CCRZ.openPDP(this)\" class='" + styleClass + " gp_prod' data-product= '" + productJSON + "' data-id= '" + SKU + "'>" + content + "</a>")
                });
                Handlebars.registerHelper('missSpaces', function (string) {
                    if (string)
                        return string.replace(' ', '');
                });
                Handlebars.registerHelper('sortCategories', function (categories, field) {
                    var result = _.sortBy(categories, function (e) {
                        if (e.children) {
                            e.children = _.sortBy(e.children, function (f) {
                                return f[field];
                            });
                        }
                        return e[field];
                    });
                    return result;
                });
                //index offset helper
                Handlebars.registerHelper('offset', function (number, options) {
                    if (typeof (number) === 'undefined' || number === null)
                        return null;
                    return number + (options.hash.offset || 0);
                });
                //set image from static resources
                Handlebars.registerHelper('setImgSrc', function (str) {
                    var currSiteURL = CCRZ.pagevars.currSiteURL,
                        themeBaseURL = "",
                        themeBaseURLArray = CCRZ.pagevars.themeBaseURL.split("/");
                    for (var i = 0; i < themeBaseURLArray.length; i++) {
                        if (themeBaseURLArray[i] && themeBaseURLArray[i].toLowerCase() != CCRZ.pagevars.storefrontName.toLowerCase()) {
                            themeBaseURL += themeBaseURLArray[i] + "/";
                        }
                    }
                    return currSiteURL + themeBaseURL + str;
                });
                Handlebars.registerHelper('displayECategoryMedia', function (catgoryMedia, options) {

                    var formattedMediaObj = CCRZ.reformatMedia(catgoryMedia);
                    var type = formattedMediaObj.ccrz__ProductMediaSource__c;
                    var url = formattedMediaObj.ccrz__FilePath__c;
                    var staticRes = formattedMediaObj.ccrz__StaticResourceName__c;
                    var buffer = "";
                    if (type == "URI")
                        return new Handlebars.SafeString(url);
                    else if (type == "Attachment")
                        return new Handlebars.SafeString(CCRZ.pagevars.attachmentURL + url);
                    else {
                        if (options.hash['ccrz__Locale__c'])
                            url = options.hash['ccrz__Locale__c'] + "/" + url;
                        if (typeof staticRes != "undefined") {
                            if (staticRes.indexOf('__') != -1) {
                                if (staticRes.startsWith('c__')) {
                                    staticRes = staticRes.slice(3);
                                }
                            } else {
                                var nspace = CCRZ.pagevars.namespace;
                                if (nspace) {
                                    if (nspace.endsWith('.')) {
                                        nspace = nspace.slice(0, nspace.length - 1);
                                    }
                                    staticRes = nspace + '__' + staticRes;
                                }
                            }
                            return new Handlebars.SafeString(CCRZ.pagevars.staticResourceMap[staticRes] + "/" + url);
                        } else {
                            return new Handlebars.SafeString(CCRZ.pagevars.themeBaseURL + url);
                        }
                    }
                });
                //overriden 'displayImage' helper
                Handlebars.registerHelper('displayImage', function (obj, styleClass, options) {
                    var blankImage = Handlebars.helpers.getReplacementImage();
                    var onerrorSrc = Handlebars.helpers.onerrorSrc();
                    if (options && options.hash['src']) {
                        var imgSrc = _.escape(options.hash['src']);
                    } else {
                        var imgSrc = CCRZ.processImageURL(obj, styleClass, options);
                    }
                    //Implemented to handle Product Image - DCM
                    if (imgSrc === '' && obj && obj.hasOwnProperty('productDescription')) {
                        imgSrc = obj.productDescription;
                    }
                    //Implemented to handle Product Image - DCM
                    if ((imgSrc === '' || imgSrc === 'undefined') && obj &&
                        obj.hasOwnProperty('EProductMediasS') && obj.EProductMediasS.length > 0) {
                        imgSrc = obj.EProductMediasS[0].productDescription;
                    }
                    if (imgSrc === '') {
                        imgSrc = blankImage;
                    }
                    var alt = '';
                    if (options && options.hash['alt']) {
                        alt = _.escape(options.hash['alt']);
                    }
                    var dataId = "";
                    if (options && options.hash['dataId']) {
                        dataId = _.escape(options.hash['dataId']);
                    }
                    if (imgSrc.length > 0) {
                        return new Handlebars.SafeString("<img class='" + styleClass + "' src='" + imgSrc + "' alt='" + alt + "' data-id='" + dataId + "' onerror='" + onerrorSrc + "'/>");
                    } else {
                        return new Handlebars.SafeString("<img class='" + styleClass + " " + CCRZ.pagevars.userLocale + " noImg' alt='" + alt + "' data-id='" + dataId + "' onerror='" + onerrorSrc + "'/>");
                    }
                });
                //return default product image src link
                Handlebars.registerHelper('getReplacementImage', function () {
                    var replacementImg = Handlebars.helpers.setImgSrc('images/img-not-available.svg');
                    return replacementImg;
                });
                //return onerror attr with replacement image
                Handlebars.registerHelper('onerrorSrc', function () {
                    return 'this.onerror=null;this.src="' + Handlebars.helpers.getReplacementImage() + '"';
                });
                //return link to Product Detail Page from SKU
                Handlebars.registerHelper('PDPLink', function (sku) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__ProductDetails?' + 'sku=' + sku + getCSRQueryString());
                });
                //return link to custom site form given pageKey
                Handlebars.registerHelper('goToCCPage_PageKey', function (pageKey) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__CCPage?pageKey=' + pageKey + getCSRQueryString());
                });
                Handlebars.registerHelper('goToCategory', function (categoryId) {
                    return new Handlebars.SafeString(CCRZ.pagevars.currSiteURL + 'ccrz__ProductList?viewState=ListView&cartId=' + CCRZ.pagevars.currentCartID + '&categoryId=' + categoryId + getCSRQueryString());
                });
                Handlebars.registerHelper("goToWishListDetails", function (data) {
                    var ret = '';
                    if (data.sfid && data.sfid != null && data.sfid != '') {
                        var link = CCRZ.pagevars.currSiteURL + "ccrz__MyAccount?viewstate=myWishlists&wishlist=" + this.sfid + "&cartId=" + CCRZ.pagevars.currentCartID + getCSRQueryString();
                        //+"&billToAccountId="+CCRZ.pagevars.remoteContext.queryParams.billToAccountId+"&shipToAccountId="+CCRZ.pagevars.remoteContext.queryParams.shipToAccountId
                        ret = new Handlebars.SafeString('<a  href="' + link + '" >' + this.name + '</a>');
                    }


                    return ret;
                });
                Handlebars.registerHelper('gridCalc', function (numOfSections) {
                    return 12 / Math.floor(numOfSections);
                });
                Handlebars.registerHelper('groupProductsCarouselItems', function (num1, num2, place) {
                    if (num2 == 1) {
                        return 'true';
                    }
                    else {
                        if (place == "begin" && (num1 == 0 || (num1 != 1 && (num1 + 1) % (num2) == 1))) return 'true';
                        else if (place == "end" && ((num1 + 1) % num2 == 0)) return 'true';
                    }
                });
                Handlebars.registerHelper('divideAndRoundUp', function (num1, num2) {
                    return Math.ceil(num1 / num2);
                });
                Handlebars.registerHelper('loop', function (n, block) {
                    var accum = '';
                    for (var i = 0; i < n; ++i)
                        accum += block.fn(i);
                    return accum;
                });
                Handlebars.registerHelper('pageLabelMap', function (labelName) {
                    var params = Array.prototype.slice.call(arguments, 1);
                    var labelSymbol = "EL#";

                    var retLabel;
                    if (labelName) {
                        if (sessionStorage.getItem("editModeOn") != 'true' && CCRZ.pagevars.pageLabels && !_.isUndefined(CCRZ.pagevars.pageLabels[labelName])) {
                            retLabel = CCRZ.pagevars.pageLabels[labelName];
                            if (_.isNull(retLabel)) {
                                retLabel = '';
                            } else if (!_.isUndefined(params) && params.length > 0) {
                                retLabel = new Handlebars.SafeString(substitute(retLabel, params));
                            } else {
                                retLabel = new Handlebars.SafeString(retLabel);
                            }
                        } else {
                            if (sessionStorage.getItem("editModeOn") == 'true') {
                                retLabel = CCRZ.pagevars.pageLabels[labelName];
                                if (_.isNull(retLabel)) {
                                    retLabel = '';
                                } else if (!_.isUndefined(params) && params.length > 0) {
                                    var editableLabel = labelSymbol + ' [' + labelName + '] ' + retLabel;
                                    retLabel = new Handlebars.SafeString(substitute(editableLabel, params));
                                } else {
                                    var editableLabel = labelSymbol + ' [' + labelName + '] ' + retLabel;
                                    retLabel = new Handlebars.SafeString(editableLabel);
                                }
                            } else {
                                retLabel = labelName;
                            }
                        }
                    }
                    if (!retLabel) {
                        retLabel = '';
                    }
                    return retLabel;
                });
                Handlebars.registerHelper('pageLabelPrefixMap', function (prefix, labelName) {
                    return Handlebars.helpers.pageLabelMap(prefix + labelName);
                });
                Handlebars.registerHelper('ifCurrentTheme', function (themeValue) {
                    var theme = (CCRZ.pagevars.themeBaseURL).split('/');
                    return theme[theme.length - 2] == themeValue;
                });
                Handlebars.registerHelper('textToHTML', function (str) {
                    return str.replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
                });
                Handlebars.registerHelper('isCSRMode', function (options) {
                    if (CCRZ && CCRZ.pagevars && CCRZ.pagevars.portalUserId != '') {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                // Removing helper userName
                /*Handlebars.registerHelper('userName', function(options){
                    return r('user').get('user') ? r('user').get('user').FirstName : '';
                });*/
                Handlebars.registerHelper('getTaxesAmountFromJSON', function (cartData) {
                    var taxesAmount = 0;
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                _.each(taxesList, function (tax) {
                                    taxesAmount += tax['Amount'];
                                })
                            }
                        }
                    }
                    return taxesAmount;
                });
                Handlebars.registerHelper('getTaxesAmountFromJSONByDescription', function (cartData, desc) {
                    var taxesAmount = 0;
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                _.each(taxesList, function (tax) {
                                    if (desc == tax['TaxDescr']) taxesAmount += tax['Amount'];
                                })
                            }
                        }
                    }
                    return taxesAmount;
                });
                Handlebars.registerHelper('containsTaxesByDescription', function (cartData, desc) {
                    if (cartData) {
                        var taxesJSON = cartData.cccustTaxesList;
                        if (taxesJSON) {
                            var taxesList = JSON.parse($.parseHTML(taxesJSON)[0].data);
                            if (taxesList) {
                                return _.some(taxesList, function (tax) {
                                    return desc == tax['TaxDescr']
                                })
                            }
                        }
                    }
                    return false;
                });
                Handlebars.registerHelper('removeAfterSign', function (text, sign) {
                    return text ? text.substr(0, text.indexOf(sign) + 1) : '';
                });
                Handlebars.registerHelper('checkoutStepNumber', function (index) {
                    return index + 1;
                });
                Handlebars.registerHelper('equalsOrLower', function (index, parentIndex, options) {
                    if (index <= parentIndex) return options.fn(this);
                    return options.inverse(this);
                });
                Handlebars.registerHelper('getViewState', function () {
                    return CCRZ.getQueryParam('viewState');
                });
                Handlebars.registerHelper('normalizeShippingMethod', function (shipMethod) {
                    return shipMethod.replace('null - ', '');
                });
                Handlebars.registerHelper('cartDiscountTotal', function (cartItems) {
                    var totalDiscount = 0;
                    if (cartItems) {
                        _.each(cartItems, function (item) {
                            if (item.attributes && item.attributes.absoluteDiscount) {
                                totalDiscount += item.attributes.absoluteDiscount;
                            } else if (item.absoluteDiscount) {
                                totalDiscount += item.absoluteDiscount;
                            }
                        });
                    }
                    return totalDiscount;
                });
                Handlebars.registerHelper('getFooterLink', function (url) {
                    var sign = '?',
                        cartParam = '',
                        CSRQueryString = getCSRQueryString(),
                        containsQuestionMark = false,
                        storefront = CCRZ.pagevars.remoteContext.storefront;

                    if (url.indexOf('www') === 0 || url.indexOf('http') === 0 || url.indexOf('https') === 0) {
                        return url;
                    }
                    if (url.indexOf("?") >= 0) {
                        sign = '&';
                        containsQuestionMark = true;
                    }
                    if (CCRZ.pagevars.currentCartID != null) {

                        cartParam = sign + 'cartId=' + CCRZ.pagevars.currentCartID;
                        containsQuestionMark = true;
                    }
                    if (containsQuestionMark == false && CSRQueryString.indexOf('&') == 0) {
                        CSRQueryString = CSRQueryString.replace('&', '?');
                    }
                    return url + cartParam + CSRQueryString;
                });
                Handlebars.registerHelper('getAbsoluteValue', function (number) {
                    return Math.abs(number);
                });
                Handlebars.registerHelper('checkCouponInCartItems', function (cartItemList) {
                    var isCouponInCart = null;
                    var coupon = 'Coupon';

                    isCouponInCart = _.find(cartItemList, function (element) {
                        return element.cartItemType == coupon || element.productType == coupon;
                    });

                    return isCouponInCart ? true : false;
                });
                Handlebars.registerHelper('checkRegisterNow', function (categoryName) {
                    if (categoryName != undefined) {
                        var targetCategory = categoryName.includes("Price Books") || categoryName.includes('Items Folders') || categoryName.includes('Contracted Items')
                            || categoryName.includes("Livres de prix") || categoryName.includes('Dossiers favoris') || categoryName.includes('ITEMS PRIX CONTRAT') ||
                            categoryName.includes("RegNow") || categoryName.includes("RegNowFordis");
                        return targetCategory;
                    }
                    return false;
                });
                Handlebars.registerHelper('checkPriceBook', function (categoryName) {
                    if (categoryName != undefined) {
                        var targetCategory = categoryName.includes("Price Books") || categoryName.includes('Items Folders') || categoryName.includes('Contracted Items');
                        return targetCategory;
                    }
                    return false;
                });
                Handlebars.registerHelper('isManager', function (options) {

                    if (CCRZ.pagevars.queryParams.isManager) {
                        if (CCRZ.pagevars.queryParams.isManager == 'true') {
                            return options.fn(this);
                        } else {
                            return options.inverse(this);
                        }

                    } else {
                        return options.inverse(this);
                    }

                });
                Handlebars.registerHelper('isNotManager', function (options) {
                    if (CCRZ.pagevars.queryParams.isManager) {
                        if (CCRZ.pagevars.queryParams.isManager == 'true') {
                            return options.inverse(this);
                        } else {
                            return options.fn(this);
                        }

                    } else {
                        return options.fn(this);
                    }

                });
                Handlebars.registerHelper('convertDateNew', function (dataToConvert) {
                    if (typeof dataToConvert === 'undefined' || dataToConvert == null || dataToConvert == '') {
                        return 'N/A';
                    }
                    //getting local time versus GMT/UTC time difference in minutes
                    let timeDifference = new Date().getTimezoneOffset();
                    let reqdateValue = parseInt(dataToConvert) + Math.abs(timeDifference) * 60 * 1000;

                    var format = CCRZ.pagevars.pageLabels['Date_Format'];
                    return util.formatDate(new Date(reqdateValue), format);
                });
                Handlebars.registerHelper('formatDateCustom', function (dataToConvert) {
                    if (typeof dataToConvert === 'undefined' || dataToConvert == null || dataToConvert == '') {
                        return '';
                    }
                    if (dataToConvert.includes('/')) {
                        var datearray = dataToConvert.split("/");
                        dataToConvert = datearray[1] + '/' + datearray[0] + '/' + datearray[2];

                    } else if (dataToConvert.includes('-')) {
                        var datearray = dataToConvert.split("-");
                        if (datearray[0].length > 2) {
                            dataToConvert = datearray[1] + '/' + datearray[2] + '/' + datearray[0];
                        } else {
                            dataToConvert = datearray[1] + '/' + datearray[0] + '/' + datearray[2];
                        }
                    }
                    return dataToConvert;
                });
                Handlebars.registerHelper('isPunchOutFlow', function (options) {
                    let isPunchOut = CCRZ.getCookie('apex__IsPunchout') ? CCRZ.getCookie('apex__IsPunchout') === 'true' : false;
                    if (isPunchOut) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('isStorefrontFlow', function (options) {
                    let isPunchOut = CCRZ.getCookie('apex__IsPunchout') ? CCRZ.getCookie('apex__IsPunchout') === 'true' : false;
                    if (isPunchOut) {
                        return options.inverse(this);
                    } else {
                        return options.fn(this);
                    }
                });
                Handlebars.registerHelper('invDataExist', function (invNum, options) {
                    let invMap = CCRZ.custom.models.VRTB2B_InvAccountSummaryCustomModel.attributes.data.ccinvMap;
                    if (invMap && invMap.hasOwnProperty(invNum)) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }
                });
                Handlebars.registerHelper('encodeText', function (value) {
                    if (value) {
                        value = value.replace(/ /g, "_");
                    }
                    return value;
                });
                Handlebars.registerHelper('getInvDataFromMap', function (invNum, field) {
                    let ret = '';
                    let invMap = CCRZ.custom.models.VRTB2B_InvAccountSummaryCustomModel.attributes.data.ccinvMap;
                    if (invMap && invMap.hasOwnProperty(invNum)) {
                        let objMap = invMap[invNum];
                        if (objMap) {
                            if (objMap.hasOwnProperty(field)) {
                                let val = objMap[field];
                                if (val && val != null) {
                                    ret = val;
                                }
                            } else if (objMap.hasOwnProperty('ShipTo__r')) {
                                if (field == 'ShipTo__r.Bill_To_Number__c') {
                                    billShipCode = objMap.ShipTo__r.Bill_To_Number__c;
                                    if (billShipCode != null && billShipCode.length > 0) {
                                        ret = billShipCode.substring(2, 8);
                                    }
                                } else if (field == 'ShipTo__r.Ship_To_Code__c') {
                                    billShipCode = objMap.ShipTo__r.Ship_To_Code__c;
                                    if (billShipCode != null && billShipCode.length > 0) {
                                        ret = billShipCode.substring(billShipCode.length - 6, billShipCode.length - 8) + "-" + billShipCode.substring(billShipCode.length - 6);
                                    }
                                }
                            }
                        }
                    }
                    return ret;
                });
                Handlebars.registerHelper('allowCreditCardPay', function (options) {
                    if (CCRZ.myaccountView && CCRZ.myaccountView.sectionMap['MyInvAccountSummaryCustomView'] && CCRZ.myaccountView.subViewArray[CCRZ.myaccountView.sectionMap['MyInvAccountSummaryCustomView']]) {
                        if (CCRZ.myaccountView.subViewArray[CCRZ.myaccountView.sectionMap['MyInvAccountSummaryCustomView']].view.model.attributes.data.allowCreditCardCheckout) {
                            return options.fn(this);
                        } else {
                            return options.inverse(this);
                        }
                    } else {
                        return options.inverse(this);
                    }

                });
                Handlebars.registerHelper('checkQuebecRegion', function (options) {
                    var ret = false;
                    var billShipCode = '';
                    if (CCRZ.pagevars.currentPageName == 'ccrz__MyAccount') {
                        if (CCRZ.myaccountModel.attributes.shipToaddress) {
                            billShipCode = CCRZ.myaccountModel.attributes.shipToaddress.shipToCode;
                        }
                    } else if (CCRZ.pagevars.currentPageName == 'ccrz__CheckoutNew') {
                        billShipCode = CCRZ.cartCheckoutModel.attributes.shipAccountToR.shipToCode;
                    } else if (CCRZ.pagevars.currentPageName == 'ccrz__OrderView' || CCRZ.pagevars.currentPageName == 'ccrz__OrderConfirmation') {
                        if (CCRZ.orderDetailModel.attributes.shippingAddress.sfid) {
                            billShipCode = CCRZ.orderDetailModel.attributes.shipAccountToR.shipToCode;
                        }
                    }
                    if (billShipCode != '') {
                        billShipCode = billShipCode.substring(billShipCode.length - 6, billShipCode.length - 8);
                        if (billShipCode == 'BD' || billShipCode == 'A1') {
                            ret = true;
                        }
                    }
                    if (ret) {
                        return options.fn(this);
                    } else {
                        return options.inverse(this);
                    }

                });
                //Helper for category template to check if it is displayed on HP or other pages
                Handlebars.registerHelper('ifHomePage', function (options) {
                    if (CCRZ.pagevars.currentPageName == 'ccrz__HomePage') {
                        return options.fn(this);
                    }
                    return options.inverse(this);
                });
                Handlebars.registerHelper('calculatePreDiscount', function (orderItems) {
                    let baseAmount = 0;
                    for (let i = 0; i < orderItems.length; i++) {
                        baseAmount += orderItems[i].price * orderItems[i].quantity;
                    }
                    return CCRZ.util.formatPrice(baseAmount);
                });
                Handlebars.registerHelper('calculateDiscount', function (orderItems) {
                    let discountAmount = 0;
                    for (let i = 0; i < orderItems.length; i++) {
                        discountAmount += orderItems[i].absoluteDiscount;
                    }
                    return CCRZ.util.formatPrice(discountAmount);
                });
                Handlebars.registerHelper('sanitizeLabelsFromTags', function (label) {
                    let fetchedLabel = CCRZ.pagevars.pageLabels["" + label + ""];
                    return fetchedLabel.replace(/<\/?[^>]+(>|$)/g, "");
                });
                initialized = true;
            }
        }
    }
});