d("quickOrderView",['util', "quickOrderModel"], function(UTIL, quickOrderModel) {

    return {
        // Quick Order View for overall usage
        extendQuickOrderView: function() {

            //Extend a new quick order View
            const defaultSize = 5, sizeIncrement = 1;var allData = new Array();
            var defaultFrequentProducts = 5;
            var counterToGetFrequentProducts = 1;
            CCRZ.views.quickOrderCustomView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.QuickOrderView.desktop.selector,
                viewName: "quickOrderView",
                templateDesktop : CCRZ.util.template(CCRZ.uiProperties.QuickOrderView.desktop.tmpl),
                templatePhone : CCRZ.util.template(CCRZ.uiProperties.QuickOrderView.desktop.tmpl),
                init: function(){
                    let v = this;
                    v.model.set('products', v.addDefaultValues(defaultSize));
                   
                    v.model.set('disableAddToCartBtn', true);
                    v.model.set('arrayData', []);
                    v.model.set('frequentProductsAdded',[]);
                    v.addDefaultFrequentValues(defaultFrequentProducts);
                    v.render();
                  
                },
                renderDesktop : function(){
                    this.renderView(this.templateDesktop(this.model.toJSON()));
                },
                renderPhone : function(){
                    this.renderView(this.templatePhone(this.model.toJSON()));
                },
                renderView: function (currTemplate) {
                    this.$el.html(currTemplate);
                    this.initializeAutoComplete();
                   
                },
                events: {
                    'dragover .dropFile' : 'handleDragOver',
                    'dragleave .dropFile' : 'handleDragLeave',
                    'drop .dropFile' : 'handleDrop',
                    'change .inputFile' : 'handleFileUpload',
                    'focus .inputSKU' : 'handleFocusSKU',
                    'blur .inputSKU' : 'handleBlurSKU',
                    'blur .inputQty' : 'handleBlurQty',
                    'click .removeItem' : 'handleRemoveItem',
                    'click .removeAll' : 'handleRemoveAll',
                    'click .inputValidate' : 'handleValidateSKU',
                    'click .inputAddToCart' : 'handleAddToCart',
                    'click .inputFrequentProductsAddToCart' : 'handleFrequentProductsAddToCart',
                    'blur .inputFreuentProdQty' : 'handleBlurFrequentProdQty',
                    'change .inputFreuentProdQty' : 'disableAddToCart',
                    //'click .downloadCsvClass' : 'downloadCsv',
                },
                initializeAutoComplete: function(event){
                    let _this = this;
                    var selectorElementArray = $('.inputSKU');
                    selectorElementArray.each(function() {
                        var selectedEle = $(this);
                        selectedEle.autocomplete({
                            minLength: 4,
                            maxShowItems: 2,
                            source: function (request, response) {
                                        $('#sidebarBackdrop').removeClass('hide');
                                        let requestData = JSON.stringify({
                                            "term" : request.term.split(/,\s*/).pop()
                                        });
                                        console.log('requestData:'+requestData);
                                        _this.model.getProducts(requestData, function(res, evt){
                                            allData = new Array();
                                            if(res && res.data && res.data.productList && res.data.productList.length > 0){
                                                for(let i = 0; i < res.data.productList.length; i++){
                                                    let prod = res.data.productList[i];
                                                    allData.push({ value: prod.Id,label:prod.SKU, description:prod.shortDesc});
                                                }
                                            }else{
                                                allData.push({ value: 'no_product', label: 'No Product Found', description: "" });
                                            }
                                            response(allData);
                                            hideMiniCart();
                                        });
                                        let requestFreqData = JSON.stringify({
                                            "frequentPurchaseBy" : "Quantity"
                                        });
                                    },
                                    select: function (event, ui) {
                                                event.preventDefault();
                                                if(ui.item.value === 'no_product'){
                                                    ui.item.label = '';
                                                    $(this).val('');
                                                }else{
                                                    $(this).val(ui.item.label);
                                                    $(this).blur();
                                                }
                                                return false;
                                            }
                        });
                        selectedEle.focus(function(){
                            if($(this).val()!='')
                                $(this).data("uiAutocomplete").search($(this).val());
                                if(allData.length>0){
                                    let noProductAdded=false;
                                    $.each(allData, function(elementOfArray, indexInArray) {
                                        if (elementOfArray.value == 'no_product') {
                                            noProductAdded = true;
                                            return false;
                                        }
                                    });
                                    if(!noProductAdded){
                                        let errorEleId = $('#error-row-msg-'+selectedEle.attr('data-row-number'));
                                        errorEleId.html('');
                                    }
                                }
                        });
                        selectedEle.data("ui-autocomplete")._renderItem = function (ul, item) {
                            if (item.value == 'no_product')//class='ui-state-disabled'
                                    return $("<li>").append("<span class='bg-danger' style='margin:0;color:red !important;'>" + item.label + "</span>").appendTo(ul);
                            else
                                    return $("<li>").append("<span class='bg-success' style='margin:0;'>" + item.label + "</span>").appendTo(ul);
                        };
                    });

                },
                showFrequentlyPurchasedProducts: function(event){
                     _this = this
                    let requestData = JSON.stringify({
                        "frequentPurchaseBy" : "Quantity"
                    });
                   let frequentProducts = [];

                   _this.model.getFrequentProducts(requestData, function(res, evt){
                    counterToGetFrequentProducts++;
                    console.log('in showFrequentlyPurchasedProducts method after res'+ JSON.stringify(res));
                    console.log('*** res.data.productList'+res.data.productList);
                        if(res && res.data && res.data.productList && res.data.productList.length > 0){
                            for(let i =0;i<res.data.productList.length;i++){
                                let prod = res.data.productList[i];
                                let image;
                                if(prod.EProductMediasS && prod.EProductMediasS.length>0){
                                    for(let j=0;j<prod.EProductMediasS.length;j++){
                                        if(prod.EProductMediasS[j].mediaType = "Product Image"){
                                            image = prod.EProductMediasS[j];
                                        }
                                    }
                               
                                }
                                if(prod.sfdcName != ''){
                                   let defaultRow = {
                                        "productSKU" : prod.SKU,
                                        "prodquantity" : 1,
                                        "proddescription" : prod.sfdcName,
                                        "proditemPrice" : prod.price,
                                        "prodLink": image,
                                        "invalidQuantity" : false,
                                        "disableAddToCartBtn" : false
                                    };
                                    frequentProducts.push(defaultRow);
                                }
                            }

                          //  _this.model.set('frequentProducts',frequentProducts);
                            console.log('*** frequent products after adding '+JSON.stringify(frequentProducts));
                            _this.model.set('frequentProducts', frequentProducts);
                                console.log('v.model.get'+JSON.stringify(_this.model.get('frequentProducts')));
                                _this.render();
                          
                        }
                        else if(res && res.data && !res.data.productList && counterToGetFrequentProducts ==2){
                           _this.showFrequentlyPurchasedProducts();
                        }
                    });
                   

                },
                handleFrequentProductsAddToCart: function(event){
                   let _this = this;
                    let products = _this.model.get('frequentProducts');
                    let quantity = 1;
                    console.log('** prod'+products);
                    let sku = event.target.dataset.sku;
                   for(let i =0;i<products.length;i++){
                    if(sku == products[i].productSKU)
                    quantity =  products[i].prodquantity;
                   }

                   console.log('quanity'+quantity)
                    
                    console.log('** sku '+sku);
                    _this.handleFrequentProductsAddToCartMethod(sku,quantity);

                },
                handleBlurFrequentProdQty: function(event){
                    let value = event.target.value, sku = event.target.dataset.sku, _this = this, products = _this.model.get('frequentProducts'), row = parseInt(event.target.dataset.rowNumber);
                    products[row].invalidQuantity = false;
                    products[row].disableAddToCartBtn = false;
                    let round =  Math.floor(value);
                    if((value != '' && value !=round) || round <=0 || value == ''){
                        value = 0 + '';
                        products[row].invalidQuantity = true;
                        products[row].disableAddToCartBtn = true;
                    }
                    products[row].prodquantity = value;
                    _this.model.set('frequentProducts', products);
                    _this.render();
                    $('#sidebarBackdrop').addClass('hide');
                   
                },
                disableAddToCart : function(event){
                    let value = event.target.value, sku = event.target.dataset.sku, _this = this, products = _this.model.get('frequentProducts'), row = parseInt(event.target.dataset.rowNumber);
                    products[row].disableAddToCartBtn = true;
                    _this.model.set('frequentProducts',products);
                    _this.render();
                    $('#sidebarBackdrop').addClass('hide');
                },
                handleFileUpload : function(event){
                    let _this = this;
                    const files = event.target.files;
                    if (files.length === 0) return;
                    if (!files[0].type.match(/text.*/) &&
                        files[0].type !== 'application/vnd.ms-excel' &&
                        !files[0].name.endsWith('.csv')) {
                            //Error Message for allowed files
                            _this.showMessage('messagingAction-error','Only csv and text file with a particular format is allowed!','ERROR');
                        return false;
                    }
                    this.readFileAsText(files[0]);
                },
                handleDragLeave : function(event){
                    event.preventDefault();
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.remove('slds-has-drag');

                    event.stopPropagation();
                },
                handleDragOver : function(event){
                    event.preventDefault();
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.add('slds-has-drag');
                    event.originalEvent.dataTransfer.dropEffect = 'move';
                    event.stopPropagation();
                },
                handleDrop : function(event){
                    event.preventDefault();
                    let _this = this;
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.remove('slds-has-drag');

                    if (event.originalEvent.dataTransfer.files.length === 0) return;
                    if (!event.originalEvent.dataTransfer.files[0].type.match(/text.*/) &&
                        event.originalEvent.dataTransfer.files[0].type !== 'application/vnd.ms-excel' &&
                        !event.originalEvent.dataTransfer.files[0].name.endsWith('.csv')) {
                            //Error Message for allowed files
                            _this.showMessage('messagingAction-error','Only csv and text file with a particular format is allowed!','ERROR');
                        return false;
                    }
                    this.readFileAsText(event.originalEvent.dataTransfer.files[0]);
                    event.stopPropagation();
                },
                //Add default values to the files
                addDefaultValues: function(size){
                    let productList = [];
                    for(let i = 0; i < size; i++){
                        let defaultRow = {
                            "sku" : "",
                            "quantity" : "",
                            "description" : "",
                            "itemPrice" : "",
                            "isInvalid" : false,
                            "isDuplicate": false,
                            "isOutOfStock": false
                        };
                        productList.push(defaultRow);
                    }
                    return productList;
                },
                 //Add default values to the files
                 addDefaultFrequentValues: function(size){
                    let frequentProductList = [];
                    let v = this;
                    setTimeout(function(){
                        
                        v.showFrequentlyPurchasedProducts();
                   
                      
                        }, 3000);
                  
                   
                  
                   // return frequentProductList;
                },

                handleBlurQty: function(event){
                    let value = event.target.value, sku = event.target.dataset.sku, _this = this, products = _this.model.get('products'), row = parseInt(event.target.dataset.rowNumber);
                    products[row].invalidQuantity = false;
                    if((value != '' && parseInt(value) <= 0) || value == ''){
                        value = 0 + '';
                        products[row].invalidQuantity = true;
                    }
                    products[row].quantity = value;
                    _this.model.set('products', products);
                    this.checkForAvailability();
                },
                handleBlurSKU: function(event){
                    let _this = this, sku = event.target.value.toUpperCase(), row = parseInt(event.target.dataset.rowNumber), type = event.target.dataset.type;
                    if(sku !== ''){
                        _this.updateCurrentProduct(type, sku, row);
                    }
                },
                handleFocusSKU: function(event){
                    let _this = this, products = _this.model.get('products');
                    if(event.target.dataset.rowNumber == (products.length - 1)){
                        let defaultRow = {
                            "sku" : "",
                            "quantity" : "",
                            "description" : "",
                            "itemPrice" : "",
                            "isInvalid" : false,
                            "isDuplicate": false,
                            "isOutOfStock": false
                        };
                        products.push(defaultRow);
                        _this.render();
                    }
                },
                handleRemoveItem: function(event){
                    let row = parseInt(event.currentTarget.dataset.rowNumber),  _this = this, products = _this.model.get('products');
                    if(products.length > 1){
                        products.splice(row, 1);
                        _this.model.set('products', products);
                    } else {
                        products.splice(row, 1);
                        products.push(_this.addDefaultValues(sizeIncrement));
                        _this.model.set('products', products);
                    }
                    this.checkForAvailability();
                },
                handleRemoveAll: function(){
                    this.model.set('products', this.addDefaultValues(defaultSize));
                    this.render();
                },
                handleValidateSKU: function(event){
                    let _this = this, copyPasteValues = $('#copyPasteValues').val(), arrayData = _this.model.get('arrayData');
                    if(arrayData.length > 0){
                        _this.getProductDetailsForBulk(arrayData, true);
                    } else if(copyPasteValues) {
                        copyPasteValues = copyPasteValues.replace(/\t/g, ',');
                        arrayData = _this.csvToArray(copyPasteValues, ',');
                        arrayData = _this.convertArrToObject(arrayData);
                        _this.updateBulkData(arrayData);
                        _this.getProductDetailsForBulk(arrayData, true);
                    }
                },
                csvToArray: function(strData, strDelimiter) {
                    const objPattern = new RegExp(("(\\" + strDelimiter + "|\\r?\\n|\\r|^)(?:\"((?:\\\\.|\"\"|[^\\\\\"])*)\"|([^\\" + strDelimiter + "\"\\r\\n]*))"), "gi");
                    let arrMatches = null, arrData = [[]];
                    while (arrMatches = objPattern.exec(strData)) {
                        if (arrMatches[1].length && arrMatches[1] !== strDelimiter) arrData.push([]);
                        arrData[arrData.length - 1].push(
                            arrMatches[2]
                                ? arrMatches[2].replace(new RegExp("[\\\\\"](.)", "g"), "$1").trim()
                                : arrMatches[3].trim()
                        );
                    }
                    return arrData;
                },
                // Read the file as text
                readFileAsText: function(file) {
                    let _this = this;
                    if (!file || file.size === 0) return null;

                    let reader = new FileReader();
                    reader.readAsText(file);

                    reader.onload = function(){ 
                        let arrayData = _this.csvToArray(reader.result, ',');
                        arrayData = _this.convertArrToObject(arrayData);
                        _this.model.set('arrayData', arrayData);
                        _this.updateBulkData(arrayData);
                        $('.inputValidate').click();
                    };

                    reader.onerror = function() {
                        throw new ReadFileException(reader.error.message);
                    };
                },
                convertArrToObject: function(arrayData){
                    let prodList = [];
                    for(let i = 0; i < arrayData.length; i++){
                        if(arrayData[i][0] != 'SKU') {
                            prodList.push({
                                "sku": arrayData[i][0].toUpperCase(),
                                "quantity": arrayData[i][1]
                            });
                        }

                    }
                    return prodList;
                },
                updateBulkData: function(skuList){
                    let productList = [];
                    for(let i = 0; i < skuList.length; i++){
                        if(skuList[i].sku != '') {
                            let product = {};
                            var qty = parseFloat(skuList[i].quantity) + '';
                            if(isNaN(qty)) {
                                qty = 0;
                            }
                            if(qty < 1) {
                                product = {
                                    "sku" : skuList[i].sku,
                                    "quantity" : qty,
                                    "description" : "",
                                    "itemPrice" : "",
                                    "isInvalid" : false,
                                    "isDuplicate": false,
                                    "isOutOfStock": false,
                                    "invalidQuantity": true
                                };
                            }
                            else {
                                product = {
                                    "sku" : skuList[i].sku,
                                    "quantity" : qty,
                                    "description" : "",
                                    "itemPrice" : "",
                                    "isInvalid" : false,
                                    "isDuplicate": false,
                                    "isOutOfStock": false,
                                    "invalidQuantity": false
                                };
                            }
                            productList.push(product);
                        }
                    }
                    console.log('--in updateBulkData-'+JSON.stringify(productList));
                    this.model.set('products', productList);
                },
                handleAddToCart: function(component){
                    $('#sidebarBackdrop').removeClass('hide');
                    let _this = this;
                    let requestData = JSON.stringify({
                        "skuList" : _this.model.get('products'),
                        "cartEncId" : CCRZ.pagevars.currentCartID
                    });
                    _this.model.addProductsToCart(requestData, function(res, evt){
                        let products = _this.model.get('products');
                        if(res && res.data){
                            _this.addDefaultValues(defaultSize);
                            CCRZ.pagevars.currentCartID = res.data;
                            CCRZ.pubSub.trigger('cartChange', res.data);
                            setTimeout(function(){
                                //_this.showMessage('messagingAction-success','Products added Successfully!','SUCCESS');
                                $('#sidebar').addClass('active'); 
                                $('.sidebarMiniCart').removeClass('hide');
                                $('#sidebarBackdrop').removeClass('hide');
                            }, 1000);
                            _this.model.set('products', _this.addDefaultValues(defaultSize));
                            _this.render();
                        } else {
                            // Error Handling
                            _this.showMessage('messagingAction-error','Error adding products!','ERROR');
                        }
                        $('#sidebarBackdrop').addClass('hide');
                    });
                },
                handleFrequentProductsAddToCartMethod: function(sku,quantity){
                    $('#sidebarBackdrop').removeClass('hide');
                    let _this = this;
                    console.log('*** 1 quantity'+quantity);
                    let requestData = JSON.stringify({
                        "sku" :sku,
                        "quantity" :quantity,
                        "cartEncId" : CCRZ.pagevars.currentCartID
                    });
                    console.log('*** requestData'+JSON.stringify(requestData));
                    _this.model.addFrequentProductsToCart(requestData, function(res, evt){
                        if(res && res.data){
                           // _this.addDefaultValues(defaultSize);
                            CCRZ.pagevars.currentCartID = res.data;
                            CCRZ.pubSub.trigger('cartChange', res.data);
                            setTimeout(function(){
                                //_this.showMessage('messagingAction-success','Products added Successfully!','SUCCESS');
                                $('#sidebar').addClass('active'); 
                                $('.sidebarMiniCart').removeClass('hide');
                                $('#sidebarBackdrop').removeClass('hide');
                            }, 1000);
                          //  _this.model.set('products', _this.addDefaultValues(defaultSize));
                            _this.render();
                        } else {
                            // Error Handling
                            _this.showMessage('messagingAction-error','Error adding products!','ERROR');
                        }
                        $('#sidebarBackdrop').addClass('hide');
                    });
                },
                checkForAvailability: function(){
                    let _this = this, productList = _this.model.get('products'), isValid = true, isSkuAvailable = false;
                    if(productList.length > 0){
                        for(let i = 0; i < productList.length; i++){
                            if((productList[i].isInvalid || productList[i].isDuplicate || productList[i].invalidQuantity)){
                                isValid = false;
                            }
                            if(productList[i].sku != ''){
                                isSkuAvailable = true;
                            }
                        }
                    }
                    _this.model.set('disableAddToCartBtn', (isSkuAvailable?!isValid:!isSkuAvailable));
                    _this.render();
                    $('#sidebarBackdrop').addClass('hide');
                },
                showMessage: function(msgClass, message, type){
                    $('.' + msgClass).html('');
                    $('.' + msgClass).removeClass('hide');
                    CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage(type, msgClass, message));
                    setTimeout(function(){
                        $('.' + msgClass).addClass('hide');
                    }, 3000);
                },
                updateCurrentProduct: function(type, value, row){
                    let _this = this, productList = _this.model.get('products'), isDuplicate = false, defaultQuantity = '0';

                    if(type == 'SKU'){
                        productList[row].sku = value;
                        productList[row].quantity = (productList[row].quantity == ''?'defaultQuantity':productList[row].quantity);
                        productList[row].invalidQuantity = false;
                        var qty = parseFloat(productList[row].quantity) + '';
                        if(isNaN(qty)) {
                            qty = 0;
                        }
                        if(qty < 1) {
                            productList[row].invalidQuantity = true;
                        }
                        
                        for(let i = 0; i < productList.length; i++){
                            if(i != row && value == productList[i].sku){
                                isDuplicate = true;
                            }
                        }
                        productList[row].isDuplicate = isDuplicate;
                    } else if(type == 'QTY'){
                        productList[row].quantity = parseInt(value);
                    }
                    productList[row].description = '';
                    productList[row].itemPrice = '';
                    productList[row].isInvalid = (isDuplicate?false:productList[row].isInvalid);
                    _this.model.set('products', productList);
                    if(isDuplicate){
                        _this.checkForAvailability();
                    } else {
                        _this.getProductDetailsForBulk([{"sku":productList[row].sku, "quantity": (productList[row].quantity + '')}], false);
                    }
                },
                getProductDetailsForBulk: function(skuList, isBulk){
                    $('#sidebarBackdrop').removeClass('hide');
                    let _this = this, prodSkuList = [];
                    for(let i = 0; i < skuList.length; i++){
                        prodSkuList.push(skuList[i].sku);
                    }
                    let requestData = JSON.stringify({
                        "skuList" : prodSkuList
                    });
                    _this.getProductDetails(requestData);
                },
                getProductDetails: function(requestData){
                    let _this = this;
                    console.log('requestData:'+requestData);
                    _this.model.getProducts(requestData, function(res, evt){
                        let products = _this.model.get('products');
                        if(res && res.data && res.data.productList && res.data.productList.length > 0){
                            for(let i = 0; i < products.length; i++){
                                console.log('products[i]',products[i]);
                                let isValid = ((products[i].description == '' && products[i].sku != '')?false:true);
                                for(let j = 0; j < res.data.productList.length; j++){
                                    let prod = res.data.productList[j];
                                    if(products[i].sku == prod.SKU){
                                        isValid = true;
                                        products[i].description = prod.sfdcName;
                                        products[i].itemPrice = prod.price;
                                    }
                                }
                                products[i].isInvalid = (isValid?false:true);
                                console.log('products[i] end',products[i]);
                            }
                            _this.model.set('products', products);
                            _this.model.set('arrayData', []);
                            $('#copyPasteValues').val('');
                            _this.checkForAvailability();
                        } else {
                            // Product not available
                            console.log('Get products: Error ');
                            for(let i = 0; i < products.length; i++){
                                if(products[i].description == '' && products[i].sku != ''){
                                    products[i].isInvalid = true;
                                }
                            }
                            _this.model.set('products', products);
                            _this.checkForAvailability();
                            _this.showMessage('messagingAction-error','Error getting product details!','ERROR');
                        }
                    });
                },
                
                // downloadCsv: function () {
                //     // var csv_string = 'PART NO,QTY' + '\n';
                //     // var filename = 'SampleTemplate.csv';
                //     // var link = document.createElement('a');
                //     // link.style.display = 'none';
                //     // link.setAttribute('target', '_blank');
                //     // link.setAttribute('href', 'data:text/csv;charset=utf-8,' + encodeURIComponent(csv_string));
                //     // link.setAttribute('download', filename);
                //     // document.body.appendChild(link);
                //     // link.click();
                //     // document.body.removeChild(link);
                //     window.open('https://tranetechnologies--dpoxboxb2b.sandbox.my.site.com/OXB2BStore/resource/OXB2B_ProductTemplate2', '_blank');

                // }
            });
            
            //Initiate Quick Order View
            CCRZ.quickOrderCustomView = new CCRZ.views.quickOrderCustomView({
                model: new quickOrderModel()
            });
        }
    }
});